/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Value       = require('./value'),
    ValueEnum   = require('./valueenum');

function TextValue(value) {
    this.value =  value || '';

    this.compareTo = function(object) {
        if(object instanceof TextValue) {
            if(this.value == null) {
                return object.value == null ? 0 : -1;
            }
            if(this.value != object.value) {
                return this.value > object.value ? 1 : -1;
            } else {
                return 0;
            }
        }
        return 1;
    };
    this.equals = function(object) {
        if(object instanceof TextValue) {
            return this.value === object.value;
        }
        return false;
    }
    this.hashCode = function() {
        var hash = 0, i, chr, len;
        if (this.value.length === 0) return hash;
        for (i = 0, len = this.value.length; i < len; i++) {
            chr   = this.charCodeAt(i);
            hash  = ((hash << 5) - hash) + chr;
            hash |= 0; // Convert to 32bit integer
        }
        return hash;
    }
}

TextValue.prototype = new Value();
TextValue.prototype.constructor = TextValue;
TextValue.prototype.write = function(dout) {
    dout.writeText(this.value);
};
TextValue.prototype.read = function(din) {
    this.value = din.readText();
    return this;
};
TextValue.prototype.getValueType = function() {
    return ValueEnum.TEXT;
};
TextValue.prototype.toObject = function() {
    return this.value;
};

module.exports = TextValue;