/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Value       = require('./value'),
    ValueEnum   = require('./valueenum'),
    ArrayUtil   = require('../util/array-util');

function IntArray(value) {
    Value.call(this);
    this.value =  value || [];
    this._hash = 0;

    this.compareTo = function(object) {
        if(object instanceof IntArray) {
            return ArrayUtil.compare(this.value, object.value);
        }
        return 1;
    };
    this.equals = function(object) {
        if(object instanceof  IntArray) {
            return ArrayUtil.equals(this.value, object.value);
        }
        return false;
    };
    this.hashCode = function() {
        if(this._hash === 0) {
            if(this.value == null) {
                return 0;
            }
            var result = 1,
                len = this.value.length;
            for(var i=0; i<len; i++) {
                var element = this.value[i];
                result = 31 * result + element;
            }
        }
        return this._hash;
    }
}

IntArray.prototype = new Value();
IntArray.prototype.constructor = IntArray;
IntArray.prototype.write = function(dout) {
    dout.writeIntArray(this.value);
};
IntArray.prototype.read = function(din) {
    this.value = din.readIntArray();
    return this;
};
IntArray.prototype.getValueType = function() {
    return ValueEnum.ARRAY_INT;
};
IntArray.prototype.toObject = function() {
    return this.value;
};

module.exports = IntArray;