/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */


var NumberValue = require('./number-value'),
    ValueEnum   = require('./valueenum'),
    Long        = require('long');

function FloatValue(value) {
    NumberValue.call(this);
    this.value = value || 0.0;
    this.compareTo = function(object) {
        if(object instanceof FloatValue) {
            if(this.value != object.value) {
                return this.value > object.value ? 1 : -1;
            } else {
                return 0;
            }
        }
        return 1;
    };
    this.equals = function(object) {
        if(object instanceof FloatValue) {
            return this.value === object.value;
        }
        return false;
    }
}

FloatValue.prototype = new NumberValue();
FloatValue.prototype.constructor = FloatValue;
FloatValue.prototype.getValueType = function() {
    return ValueEnum.FLOAT;
};
FloatValue.prototype.write = function(dout) {
    dout.writeFloat(this.value);
};
FloatValue.prototype.read = function(din) {
    this.value = din.readFloat();
    return this;
};
FloatValue.prototype.toObject = function() {
    return this.value;
};
FloatValue.prototype.doubleValue = function() {
    return this.value;
};
FloatValue.prototype.floatValue = function() {
    return this.value;
};
FloatValue.prototype.intValue = function() {
    return parseInt(this.value);
};
FloatValue.prototype.longValue = function() {
    return Long.fromNumber(this.value);
};
FloatValue.prototype.numberValue = function() {
    return this.value;
};


module.exports = FloatValue;