/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var HashUtil    = require('../util/hashutil'),
    ValueEnum   = require('./valueenum'),
    Value       = require('./value');

function BlobValue(value) {
    Value.call(this);
    this.value = (value instanceof Buffer) ? value :  Buffer.alloc(0);
    this.compareTo = function(object) {
        if(object instanceof BlobValue) {
            if(this.value == null) {
                return object.value == null ? 0 : -1;
            }
            return this.value.compare(object.value);
        }
        return 1;
    };
    this.equals = function(object) {
        if(object instanceof  BlobValue) {
            if(this.value == null) {
                return object.value == null;
            }
            return this.value.equals(object.value);
        }
        return false;
    };
    this.hashCode = function(){
        if(this.value == null) {
            return 0;
        }
        return HashUtil.hash(this.value);
    };
    this.toString = function() {
        if(this.value == null) {
            return null;
        }
        return "byte[" + this.value.length + "]";
    };
}

BlobValue.prototype = new Value();
BlobValue.prototype.constructor = BlobValue;
BlobValue.prototype.read = function(din) {
    this.value = din.readBlob();
    return this;
};
BlobValue.prototype.write = function(dout) {
    dout.writeBlob(this.value);
};
BlobValue.prototype.getValueType = function() {
    return ValueEnum.BLOB;
};
BlobValue.prototype.toObject = function() {
    return this.value;
}

module.exports = BlobValue;