const conf = require('../conf/configure');
const Hexa32 = require("../util/hexa32");

var Transfer = function () {
    this.PCODE = 0;
    this.OID = 0;
    this.ONAME = null;
    this.OKIND = 0;
    this.OKIND_NAME = null;
    this.ONODE = 0;
    this.ONODE_NAME = null;
    this.transfer_poid;

    this.PCODE = conf.on('PCODE', function (PCODE) {
        this.PCODE = PCODE;
    });
    this.OID = conf.on('OID', function (OID) {
        this.OID = OID;
    });
    this.ONAME = conf.on('ONAME', function (ONAME) {
        this.ONAME = ONAME;
    });
    this.OKIND = conf.on('OKIND', function (OKIND) {
        this.OKIND = OKIND;
    });
    this.OKIND_NAME = conf.on('OKIND_NAME', function (OKIND_NAME) {
        this.OKIND_NAME = OKIND_NAME;
    });
    this.ONODE = conf.on('ONODE', function (ONODE) {
        this.ONODE = ONODE;
    });
    this.ONODE_NAME = conf.on('ONODE_NAME', function (ONODE_NAME) {
        this.ONODE_NAME = ONODE_NAME;
    });
}

Transfer.prototype.POID = function () {
    if (this.transfer_poid)
        return this.transfer_poid;
    this.transfer_poid = Hexa32.toString32(this.PCODE) + ',' + Hexa32.toString32(this.OKIND) + ',' + Hexa32.toString32(this.OID);
    return this.transfer_poid;
}
Transfer.prototype.MTID_CALLERTX = function (ctx) {
    if (ctx.transfer_id)
        return ctx.transfer_id;
    var x = Hexa32.toString32(ctx.mtid) + ',' + (ctx.mdepth + 1) + ',' + Hexa32.toString32(ctx.id);
    ctx.transfer_id = x;
    return ctx.transfer_id;
}
Transfer.prototype.SPEC_URL = function (ctx) {
    if (ctx.transfer_info)
        return ctx.transfer_info;
    var x = conf.mtrace_spec + ',' + ctx.service_hash;
    ctx.transfer_info = x;
    return ctx.transfer_info;
}

module.exports = new Transfer();