const conf = require('../conf/configure'),
    AsyncSender = require('../udp/async_sender'),
    PacketTypeEnum = require('../udp/packet_type_enum');

var TraceHttpc = function () {}
TraceHttpc.prototype.isSlowHttpc = function (ctx) {
    if(!ctx)
        return;
    var profile_error_httpc_time_max = conf.getProperty('profile_error_httpc_time_max', 10000);

    if(ctx.elapsed && (ctx.elapsed > profile_error_httpc_time_max)){
        if (!ctx.error) ctx.error = 1;
        ctx.status = 500;

        var errors = ['SlOW_HTTPC', 'SlOW HTTPC'];
        AsyncSender.send_packet(PacketTypeEnum.TX_ERROR, ctx, errors);
    }
}

module.exports = new TraceHttpc();