/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Value       = require('./value'),
    ValueEnum   = require('./valueenum'),
    Long        = require('long');

function LongArray(value) {
    Value.call(this);
    this.value = value || [];
    this.hash = 0;
    this.compareTo = function(object) {
        if(object instanceof LongArray) {
            return ArrayUtil.compare(this.value, object.value);
        }
        return 1;
    };
    this.equals = function(object) {
        if(object instanceof LongArray) {
            return ArrayUtil.equals(this.value, object.value);
        }
        return false;
    };

    this.hashCode = function() {
        if(this.hash === 0) {
            if(this.value == null) {
                return 0;
            }
            var result = 1,
                len = this.value.length;
            for(var i=0; i<len; i++) {
                var element = this.value[i];
                result = 31 * result + element.toInt();
            }
        }
        return this.hash;
    };
}

LongArray.prototype = new Value();
LongArray.prototype.constructor = LongArray;
LongArray.prototype.write = function(dout) {
    dout.writeLongArray(this.value);
};
LongArray.prototype.read = function(din) {
    this.value = din.readLongArray();
    return this;
};
LongArray.prototype.getValueType = function() {
    return ValueEnum.ARRAY_LONG;
};
LongArray.prototype.toObject = function() {
    return this.value;
};

module.exports = LongArray;