/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */


var NumberValue = require('./number-value'),
    ValueEnum   = require('./valueenum'),
    Long        = require('long');

function IntValue(value) {
    NumberValue.call(this);
    this.value = value || 0;
    this.compareTo = function(object) {
        if(object instanceof IntValue) {
            if(this.value != object.value) {
                return this.value > object.value ? 1 : -1;
            } else {
                return 0;
            }
        }
        return 1;
    };
    this.equals = function(object) {
        if(object instanceof IntValue) {
            return this.value === object.value;
        }
        return false;
    }
}

IntValue.prototype = new NumberValue();
IntValue.prototype.constructor = IntValue;
IntValue.prototype.getValueType = function() {
    return ValueEnum.DECIMAL_INT;
};
IntValue.prototype.write = function(dout) {
    dout.writeInt32BE(this.value);
};
IntValue.prototype.read = function(din) {
    this.value = din.readInt32BE();
    return this;
};
IntValue.prototype.toObject = function() {
    return this.value;
};
IntValue.prototype.doubleValue = function() {
    return this.value;
};
IntValue.prototype.floatValue = function() {
    return this.value;
};
IntValue.prototype.intValue = function() {
    return this.value;
};
IntValue.prototype.longValue = function() {
    return Long.fromNumber(this.value);
};
IntValue.prototype.numberValue = function() {
    return this.value;
};


module.exports = IntValue;