/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Long        = require('long'),
    ValueEnum   = require('./valueenum'),
    NumberValue = require('./number-value');

function DecimalValue(value) {
    NumberValue.call(this);
    if(value instanceof  Long) {
        this.value = value;
    } else if(typeof value === 'number') {
        this.value = Long.fromNumber(value);
    } else if(typeof value === 'string') {
        this.value = Long.fromString(value);
    } else {
        this.value = Long.ZERO;
    }

    this.compareTo = function(object) {
        if(object instanceof  DecimalValue) {
            return this.value.compare(object.value);
        }
        return 1;
    };
    this.equals = function(object) {
        if(object instanceof DecimalValue) {
            return this.value.equals(object.value);
        }
        return false;
    }
    this.hashCode = function()  {
        var hash = this.value.low ^ this.value.high;
        return hash;
    }
    this.toString = function() {
        return this.value.toString();
    }
}

DecimalValue.prototype = new NumberValue();
DecimalValue.prototype.constructor = NumberValue;
DecimalValue.prototype.write = function(dout) {
    dout.writeDecimal(this.value);
};
DecimalValue.prototype.read = function(din) {
    this.value = din.readDecLong(); //무조건 Long 타입으로 처리한다. 
    return this;
};
DecimalValue.prototype.getValueType = function() {
    return ValueEnum.DECIMAL;
};
DecimalValue.prototype.doubleValue = function() {
    return this.value.toNumber();
};
DecimalValue.prototype.floatValue = function() {
    return this.value.toNumber();
};
DecimalValue.prototype.intValue = function() {
    return this.value.toInt();
};
DecimalValue.prototype.longValue = function() {
    return this.value;
};
DecimalValue.prototype.numberValue = function() {
    return this.value.toNumber();
};

module.exports = DecimalValue;