/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */


var LinkedMap   = require('./linkedmap'),
    HashUtil = require('./hashutil');

function StringSet(initCapacity, loadFactor){
    LinkedMap.call(this, initCapacity, loadFactor);
    return this;
}

StringSet.prototype = new LinkedMap();
StringSet.prototype.constructor = StringSet;

StringSet.prototype.hash = function (key /*string*/) {
    return  Math.abs(this.strHash(key));
}
StringSet.prototype.equals = function (key1, key2) {
    return key1 === key2;
};
StringSet.prototype.sum = function (key1, key2) {
    return key2;
};

StringSet.prototype.add = function (key) {
    return this._put(key, key, LinkedMap.MODE.LAST);
};
StringSet.prototype.put = function (key) {
    return this._put(key, key, LinkedMap.MODE.LAST);
};
StringSet.prototype.putLast = function (key) {
    return this._put(key, key, LinkedMap.MODE.FORCE_LAST);
};
StringSet.prototype.putFirst = function (key) {
    return this._put(key, key, LinkedMap.MODE.FORCE_FIRST);
};
StringSet.prototype.hasKey = function (key) {
    return this.containsKey(key);
};
StringSet.prototype.forEach=function(f){
    var en = this.keys();
    while(en.hasMoreElements()) {
        var e = en.nextElement();
        f(e);
    }
}

StringSet.prototype.toString = function () {
    var str = '';
    var it = this.keys();
    str += '{';
    for(var i=0; it.hasMoreElements(); i++) {
        var e = it.nextElement();
        if(i > 0) {
            str += ", ";
        }
        str += e;
    }
    str += "}";
    return str;
};
module.exports = StringSet;