/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */


var LinkedMap   = require('./linkedmap'),
    HashUtil = require('./hashutil');;

function StringNumLinkedMap(initCapacity, loadFactor){
    LinkedMap.call(this, initCapacity, loadFactor);
    return this;
}

StringNumLinkedMap.prototype = new LinkedMap();
StringNumLinkedMap.prototype.constructor = StringNumLinkedMap;

StringNumLinkedMap.prototype.none = function () {
    return 0;
};
StringNumLinkedMap.prototype.hash = function (key /*string*/) {
    return  Math.abs(this.strHash(key));
}
StringNumLinkedMap.prototype.equals = function (key1, key2) {
    return key1 === key2;
};
StringNumLinkedMap.prototype.sum = function (key1, key2) {
    return key1+key2;
};

module.exports = StringNumLinkedMap;