/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var LinkedMap   = require('./linkedmap'),
    Long        = require('long');


function LongLongLinkedMap(initCapacity, loadFactor) {
    LinkedMap.call(this, initCapacity, loadFactor);
    return this;
}
function LongLongLinkedMap(initCapacity, loadFactor) {
    LongKeyLinkedMap.call(this, initCapacity, loadFactor);
    return this;
}
LongLongLinkedMap.prototype = new LinkedMap();
LongLongLinkedMap.prototype.constructor = LongLongLinkedMap;

LongLongLinkedMap.prototype.none = function () {
    return 0;
};
LongLongLinkedMap.prototype.hash = function (key /*long*/) {
    return Math.abs(key.toNumber());
};
LongLongLinkedMap.prototype.equals = function (key1, key2) {
    if(key1===key2){
        return true;
    }
    return key1.equals(key2);
};
LongLongLinkedMap.prototype.sum = function (value1, value2) {
    return value1.add(value2);
};

module.exports = LongLongLinkedMap;