/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var LinkedMap = require('./linkedmap'),
    Long      = require('long');

function IntKeyLinkedMap(initCapacity, loadFactor) {
    LinkedMap.call(this, initCapacity, loadFactor);
}

IntKeyLinkedMap.prototype = new LinkedMap();
IntKeyLinkedMap.prototype.constructor = IntKeyLinkedMap;

IntKeyLinkedMap.prototype.hash = function (key /*int*/) {
    return Math.abs(key);
};
IntKeyLinkedMap.prototype.equals = function (key1, key2) {
    return key1===key2;
};
IntKeyLinkedMap.prototype.sum = function (value1, value2) {
    return value2;
};

module.exports = IntKeyLinkedMap;