/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Long = require('long');

function BitUtil() {}

BitUtil.composite = function (hkey, wkey) {
    return Long.fromBits(wkey, hkey);
};
BitUtil.getHigh = function (key) {

    if(typeof key === 'number') {
        return key & 0xffffffff;
    }
    return key.getHighBits() & 0xffffffff;
};
BitUtil.getLow = function (key) {
    if(typeof key === 'number') {
        return key & 0xffffffff;
    }
    return key.getLowBits() & 0xffffffff;
};

module.exports = BitUtil;