/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */


var Value = require('./value');

function NumberValue() {
    Value.call(this);
};

NumberValue.prototype = new Value();
NumberValue.prototype.constructor = NumberValue;
NumberValue.prototype.doubleValue = function(){return 0;};
NumberValue.prototype.floatValue = function(){return 0;};
NumberValue.prototype.intValue = function(){return 0;};
NumberValue.prototype.longValue = function(){return Long.ZERO;};
NumberValue.prototype.numberValue = function() {return 0;};

NumberValue.prototype.add = function(num) {
    if(num == null || !(num instanceof NumberValue)) {
        return this;
    }
   
    if(this.value instanceof Long){
        this.value = this.value.add(num.value);
    }else{
        this.value += num.value;
    }
    return this;
};

module.exports = NumberValue;