/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */


var LinkedMap   = require('./linkedmap'),
    HashUtil = require('./hashutil');;

function StringKeyLinkedMap(initCapacity, loadFactor){
    LinkedMap.call(this, initCapacity, loadFactor);
    return this;
}

StringKeyLinkedMap.prototype = new LinkedMap();
StringKeyLinkedMap.prototype.constructor = StringKeyLinkedMap;

StringKeyLinkedMap.prototype.hash = function (key /*string*/) {
    return  Math.abs(this.strHash(key));
}
StringKeyLinkedMap.prototype.equals = function (key1, key2) {
    return key1 === key2;
};
StringKeyLinkedMap.prototype.sum = function (key1, key2) {
    return key2;
};

module.exports = StringKeyLinkedMap;