/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var fs      = require('fs'),
    path    = require('path');
const { execSync } = require('child_process');

function getPackageJson() {
    try {
        const whatapPath = require.resolve('whatap/package.json');
        NodeUtil.packageJson = require(whatapPath);
        return;
    } catch(e) {
    }

    try{
        const globalPath = execSync('npm root -g').toString().trim();
        const globalWhatapPath = path.join(globalPath, 'whatap', 'package.json');
        NodeUtil.packageJson = require(globalWhatapPath);
        return;
    }catch (e) {
    }
    NodeUtil.packageJson = {};
}
function recursiveCall(fullPath, file, cb){
    if(fullPath === undefined) return;

    if(fullPath && fullPath.length < 3 ) {
        if(cb) return cb('root');
    }

    fs.access( path.join( fullPath, file) , function(err,data){
        if(err && err.code == "ENOENT"){
            return recursiveCall( path.resolve(fullPath , '..') , file, cb);
        }else if(err){
            return cb( err );
        }else{
            return cb(null, path.join( fullPath, file ) );
        }
    });
}

var NodeUtil = {
    getVersion: function(){
        return this.packageJson['version'] || 'unknown';
    },
    getName: function(){
        return this.packageJson['name'] || 'WhaTap APM';
    },
    getTimeZone: function(){
        var d = new Date();
        //var dateString = d.toString();
        var dateString = d.getTimezoneOffset();

        if(dateString < 0) dateString = "GMT+" + ((100 + Math.abs(dateString/60)) + '00').substr(1);
        else if(dateString > 0) dateString = "GMT-" + ((100 + Math.abs(dateString/60)) + '00').substr(1);
        else dateString = "GMT";
        //return /GMT[!\S]*/.exec(dateString)[0];
        return dateString;
    },
    getReleaseDate: function(){
        return this.packageJson['releaseDate'] || 'unknown';
    },
    recursiveCall: recursiveCall,
    getPackageJson : getPackageJson,
    packageJson : {},

    // Node.js 버전 정보 함수들 추가
    getNodeVersion: function() {
        return process.version;
    },

    getNodeMajorVersion: function() {
        return parseInt(process.version.split('.')[0].substring(1));
    },

    getNodeMinorVersion: function() {
        return parseInt(process.version.split('.')[1]);
    },

    getNodePatchVersion: function() {
        return parseInt(process.version.split('.')[2]);
    },

    // GC Observer 지원 여부 체크
    hasStableGCObserver: function() {
        const major = this.getNodeMajorVersion();
        const minor = this.getNodeMinorVersion();

        return major >= 17 || (major >= 16 && minor >= 7);
    },

    // 버전 비교 함수
    compareNodeVersion: function(targetMajor, targetMinor, targetPatch) {
        const major = this.getNodeMajorVersion();
        const minor = this.getNodeMinorVersion();
        const patch = this.getNodePatchVersion();

        if (major > targetMajor) return 1;
        if (major < targetMajor) return -1;

        if (minor > targetMinor) return 1;
        if (minor < targetMinor) return -1;

        if (patch > targetPatch) return 1;
        if (patch < targetPatch) return -1;

        return 0; // 동일
    }
};

module.exports = NodeUtil;
