/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */


var LinkedMap   = require('./linkedmap'),
    Long        = require('long');

function LongKeyLinkedMap(initCapacity, loadFactor){
    LinkedMap.call(this, initCapacity, loadFactor);
    return this;
}

LongKeyLinkedMap.prototype = new LinkedMap();
LongKeyLinkedMap.prototype.constructor = LongKeyLinkedMap;

LongKeyLinkedMap.prototype.hash = function (key /*long*/) {
    return Math.abs(key.toNumber());
};
LongKeyLinkedMap.prototype.equals = function (key1, key2) {
    return key1.equals(key2);
};

module.exports = LongKeyLinkedMap;