/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

function num(k, defValue){
    var v=process.env[k];
    return v?Number(v):defValue;
};
function bool(k, defValue){
    var v=process.env[k];
    return v?Boolean(v):defValue;
};
function str(k, defValue){
    var v=process.env[k];
    return v?v:defValue;
};
var LogConfigDefault = {
    "logsink_enabled": bool("logsink_enabled", false),
    "logsink_zip_enabled": bool("logsink_zip_enabled", false),
    "logsink_category_stdout": "AppStdOut",
    "logsink_category_stderr": "AppStdErr",
    "logsink_queue_size": num("logsink_queue_size", 500),
    "logsink_limit_content_enabled": bool("logsink_limit_content_enabled", true),
    "logsink_limit_content_length": num("logsink_limit_content_length", 10000),
    "logsink_max_content_log_enabled": bool("logsink_max_content_log_enabled", true),
    "logsink_max_content_alert_enabled": bool("logsink_max_content_alert_enabled", false),
    "logsink_max_content_alert_silent_time": num("logsink_max_content_alert_silent_time", 10000),
    "logsink_trace_txid_enabled": bool("logsink_trace_txid_enabled", true),
    "logsink_trace_mtid_enabled": bool("logsink_trace_mtid_enabled", true),
    "logsink_high_secure_enabled": bool("logsink_high_secure_enabled", false),
    "debug_logsink_zip_enabled": bool("debug_logsink_zip_enabled", false),
    "logsink_max_buffer_size": num("logsink_max_buffer_size", 1024*64),
    "logsink_max_wait_time": num("logsink_max_wait_time", 2000),

    "pii_mask_logsink_enabled": bool("pii_mask_logsink_enabled", false),
    "pii_mask_logsink_items": str("pii_mask_logsink_items", ""),
    "pii_mask_logsink_replace": str("pii_mask_logsink_replace", "***"),

    "pii_mask_sql_enabled": bool("pii_mask_sql_enabled", false),
    "pii_mask_sql_items": str("pii_mask_sql_items", ""),
    "pii_mask_sql_replace": str("pii_mask_sql_replace", "pii-included"),

};
module.exports = LogConfigDefault;