/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var path = require('path');
function num(k, defValue){
    var v=process.env[k];
    return v?Number(v):defValue;
};
function bool(k, defValue){
    var v=process.env[k];
    return v ? (v === 'true') : defValue;
};
function str(k, defValue){
    var v=process.env[k];
    return v?v:defValue;
};
var ConfigDefault = {
    "whatap.home": '',
    "whatap.enabled": bool('whatap.enabled',true),
    "license" : str("license", null),
    "counter_enabled": bool('counter_enabled',true),
    "stat_enabled": bool('stat_enabled',true),

    "profile_enabled": bool('profile_enabled',true),
    "sql_enabled": bool('sql_enabled',true),
    "httpc_enabled": bool('httpc_enabled',true),
    "profile_max_time" : num('profile_max_time',300000),
    "profile_max_count" : num('profile_max_count',10000),
    "prepared_sql_max": 5001,

    "trace_service_name_header_key": null,
    "trace_service_name_key": null,
    "web_static_content_extensions": str("web_static_content_extensions" , "js, htm, html, gif, png, jpg, css, txt, ico"),
    "trace_auto_service_enabled": false,
    "trace_auto_service_backstack_enabled": true,
    "trace_background_socket_enabled": bool('trace_background_socket_enabled', true),
    "trace_node_schedule_enabled": bool('trace_node_schedule_enabled',false),
    "trace_active_callstack_depth": 40,
    "trace_activeserivce_yellow_time": 3000,
    "trace_activeservice_red_time": 8000,
    "trace_activeservice_hang_time": 6000,

    "trace_httpc_normalize_urls": "",
    "log_ignore_set": null,
    "whatap.server.host": str('whatap_server_host',"127.0.0.1,127.0.0.1"),
    "whatap.server.port": num('whatap_server_port',6600),
    "tcp_connection_timeout": num('tcp_connection_timeout',10000),
    "tcp_so_timeout": 60000,
    "net_send_max_bytes": 5 * 1024 * 1024,
    "net_send_queue1_size": 512,
    "net_send_queue2_size": 1024,
    "hook_connection_open_patterns": "",
    "log_datasource_lookup_enabled": true,

    "profile_http_querystring_enabled": bool('profile_http_querystring_enabled',false),
    "profile_http_header_enabled": bool('profile_http_header_enabled',false),
    "profile_http_header_ignore_keys": str('profile_http_header_ignore_keys','Cookie,cookie,accept,user-agent,referer'),
    "profile_http_parameter_enabled": bool('profile_http_parameter_enabled',false),
    "profile_http_parameter_keys": str('profile_http_parameter_keys',''),
    "profile_httpc_parameter_enabled": bool('profile_httpc_parameter_enabled',false),
    "profile_http_parameter_url_prefix": "/",
    "profile_http_header_url_prefix": "/",
    "profile_connection_open_enabled": true,
    "profile_zip_enabled": bool('profile_zip_enabled', false),
    "profile_zip_queue_size": num('profile_zip_queue_size', 500),
    "profile_zip_max_buffer_size": num('profile_zip_max_buffer_size', 1024*1024),
    "profile_zip_min_size": num('profile_zip_min_size', 100),
    "debug_profile_zip_enabled": bool('debug_profile_zip_enabled', false),
    "debug_profile_zip_interval": num('debug_profile_zip_interval', 5000),
    "profile_zip_max_wait_time": num('profile_zip_max_wait_time', 1000),
    "profile_zip_max_wait2_time": num('profile_zip_max_wait2_time', 5000),

    "hook_method_patterns": str('hook_method_patterns',""),
    "hook_method_access_public_enabled": true,
    "hook_method_access_protected_enabled": true,
    "hook_method_access_private_enabled": false,
    "hook_method_access_none_enabled": true,
    "hook_method_ignore_prefixes": "get,set",
    "hook_method_ignore_classes": "",
    "profile_method_enabled": true,

    "hook_service_patterns": "",
    "hook_httpc_patterns": "",
    "hook_httpc_info_patterns": "",
    "hook_trace_helper_start_patterns": "",
    "hook_trace_helper_end_patterns": "",
    "hook_dyna_ignore_count": 100,
    "profile_step_max_count": 1024,
    "profile_fullstack_max_lines": 0,
    "profile_basetime": num('profile_basetime',500),
    "trace_http_client_ip_header_key": str('trace_http_client_ip_header_key','x-forwarded-for'),
    "trace_user_agent_header_key": str('trace_user_agent_header_key',''),
    "trace_referer_header_key": str('trace_referer_header_key',''),
    "profile_sql_param_enabled": bool('profile_sql_param_enabled',false),
    "profile_sql_resource_enabled": bool('profile_sql_resource_enabled',false),
    "error_snap_enabled" : true,
    "trace_user_enabled": bool('trace_user_enabled',true),
    "trace_user_using_ip": bool('trace_user_using_ip',true),
    "trace_user_using_jsession": false,
    "user_header_ticket": str('user_header_ticket',''),
    "user_header_ticket_enabled": bool('user_header_ticket_enabled',false),
    "trace_user_cookie_limit": 2048,
    "trace_sql_error_stack": bool('trace_sql_error_stack', false),
    "trace_sql_error_depth": num('trace_sql_error_depth', 50),
    "transaction_status_error_enable": bool("transaction_status_error_enable", true),

    "trace_sampling_enabled": bool("trace_sampling_enabled", true),
    "trace_sampling_tps": bool("trace_sampling_tps", 1000),

    "profile_error_step_enabled": bool('profile_error_step_enabled', true),
    "profile_error_sql_time_max": num("profile_error_sql_time_max", 30000),
    "profile_error_sql_fetch_max": num("profile_error_sql_fetch_max", 10000),
    "profile_error_httpc_time_max": num("profile_error_httpc_time_max", 10000),
    "hook_direct_patch_classes": "",

    "log_rotation_enabled": bool('log_rotation_enabled',true),
    "log_oname_enabled": bool('log_oname_enabled',false),
    "log_keep_days": num('log_keep_days' , 7),
    "log_print_enabled": bool('log_print_enabled',true),
    "log_file_enabled" : bool('log_file_enabled',true),
    "thread_dump_enabled": bool('thread_dump_enabled',false),
    "debug_cpu_enabled": bool('debug_cpu_enabled',false),

    "cipher_net_enabled": true,
    "cipher_level": 2,
    'cypher_level': 128,
    "boot_redefine_size": 100,

    "counter_interval": 5000,
    "CONFIG_INITED": true,

    // "_profile_position_httpc_hash": 0,
    // "profile_position_httpc": "",
    // "_profile_position_sql_hash": 0,
    // "profile_position_sql": "",
    // "_profile_position_method_hash": 0,
    // "profile_position_method": "",
    // "profile_position_depth": 50,
    "trace_normalize_urls" : str('trace_normalize_urls',''),
    "trace_auto_normalize_enabled" : bool('trace_auto_normalize_enabled',false),
    "trace_normalize_enabled" : bool('trace_normalize_enabled',true),
    "trace_active_transaction_yellow_time" : num('trace_active_transaction_yellow_time', 3000),
    "trace_active_transaction_red_time" : num('trace_active_transaction_red_time', 8000),
    "trace_active_transaction_hang_time" : num('trace_active_transaction_hang_time', 30000),
    "realtime_user_thinktime_max" : 300000,
    "trace_service_port_enabled" :  bool('trace_service_port_enabled',false),
    "ignore_http_method": str('ignore_http_method', 'PATCH,OPTIONS,HEAD,TRACE'),
    "status_ignore": str('status_ignore', ''),
    "httpc_status_ignore": str('httpc_status_ignore', ''),
    "status_ignore_set": str('status_ignore_set', ''),
    "httpc_status_ignore_set": str('httpc_status_ignore_set', ''),
    "trace_sql_normalize_enabled" : true,
    "httpc_not_found_ignore": bool('httpc_not_found_ignore', false),
    "httpc_not_found_ignore_time": num('httpc_not_found_ignore', 300000),
    "ignore_sql_error_code_set": str('ignore_sql_error_code_set', ''),
    "ignore_build_file_enabled": bool('ignore_build_file_enabled', true),
    "ignore_build_file_path": str('ignore_build_file_path', '/_next/'),

    //2017.05.02 AUTO ONAME
    "auto_oname_enabled" : bool('auto_oname_enabled',false),
    "auto_oname_prefix" : str('auto_oname_prefix','nodejs'),
    "auto_oname_reset" : num('auto_oname_reset',0) ,
    "log_pack_data" : false,

    //2018.10.02 MT
    "mtrace_rate" : num('mtrace_rate',10) ,
    "mtrace_spec" : str('mtrace_spec','v1'),
    "mtrace_spec_hash" : num('mtrace_spec_hash',0),
    "stat_mtrace_enabled" : bool('stat_mtrace_enabled',false),
    "stat_domain_enabled" : bool('stat_domain_enabled',false),

    //2019.1.24
    "mtrace_enabled" : bool('mtrace_enabled',false),
    "sql_dbc_meter_enabled" : bool('sql_dbc_meter_enabled',false),
    "httpc_host_meter_enabled" : bool('httpc_host_meter_enabled',false),
    "tx_caller_meter_enabled" : bool('tx_caller_meter_enabled',false),
    "actx_meter_enabled" : bool('actx_meter_enabled',false),

    "mtrace_callee_txid_enabled" : bool('mtrace_callee_txid_enabled',false),
    "whatap.okind" : str('whatap.okind',''),

    "trace_referer_enabled" : bool('trace_referer_enabled',false),

    "debug_tcpsend" : bool('debug_tcpsend',false),

    "trace_ignore_url_set": str('trace_ignore_url_set',""),
    "_trace_ignore_url_set": {},
    "trace_ignore_url_prefix": str('trace_ignore_url_prefix',''),
    "_is_trace_ignore_url_prefix": false,

    "trace_ignore_err_cls_contains": str('trace_ignore_err_cls_contains',''),
    "_is_trace_ignore_err_cls_contains": false,
    "trace_ignore_err_msg_contains": str('trace_ignore_err_msg_contains',''),
    "_is_trace_ignore_err_msg_contains": false,

    "trace_origin_url": bool('trace_origin_url',false),
    //2019.12.12 Kubernetes
    "whatap_kubernetes_enabled": bool('whatap_kubernetes_enabled',false),
    "pod_name": str('pod_name', ''),
    "whatap_micro_enabled": bool('whatap_micro_enabled',false),
    "master_agent_host": str('master_agent_host', 'whatap-master-agent.whatap-monitoring.svc.cluster.local'),
    "master_agent_port": num('master_agent_port', 6600),
    "enabled_master_agent_call": bool('enabled_master_agent_call' , false),

    "simula_agent_count": num('simula_agent_count', 0),
    "correction_factor_cpu": num('correction_factor_cpu', 1),
    "aws_ecs_enabled": bool('aws_ecs_enabled', true),
    "aws_ecs_stat_interval": num('aws_ecs_stat_interval', 3000),

    // stat_service1_enabled
    "stat_service1_enabled": bool('stat_service1_enabled', true),
    "stat_mtrace_max_count": num('stat_mtrace_max_count', 7000),

    "_trace_mtrace_poid_key": str("mtrace_poid_key", "x-wtap-po"),
    "_trace_mtrace_caller_key": str("mtrace_caller_key","x-wtap-mst"),
    "_trace_mtrace_callee_key": str("mtrace_callee_key","x-wtap-tx"),
    "_trace_mtrace_spec_key1": str("mtrace_spec_key", "x-wtap-sp1"),
    "_trace_mtrace_ip": str("mtrace_ip", "x-wtap-ip"),

    // add apdex 2020.11.13
    "apdex_time_t": num('apdex_time_t', 1200),
    "apdex_time_4t": num('apdex_time_4t', 1200 * 4),
    "debug_apdex_enabled": bool('debug_apdex_enabled', false),

    // debug add
    "network_debug_enabled" : bool('network_debug_enabled', false),
    // reqlog add
    "reqlog_rotation_enabled": true,
    "reqlog_keep_days": 7,
    "reqlog_enabled": bool('reqlog_enabled', false),
    "reqlog_seperator" : str('reqlog_seperator', '|'),

    "reqlog_x_etime" : bool('reqlog_x_etime', true),
    "reqlog_x_elapsed" : bool('reqlog_x_elapsed', true),
    "reqlog_x_url" : bool('reqlog_x_url', true),
    "reqlog_x_httphost" : bool('reqlog_x_httphost', true),
    "reqlog_x_method" : bool('reqlog_x_method', true),
    "reqlog_x_ip" : bool('reqlog_x_ip', true),
    "reqlog_x_wcid" : bool('reqlog_x_wcid', true),
    "reqlog_x_status" : bool('reqlog_x_status', true),
    "reqlog_x_error" : bool('reqlog_x_error', true),
    "reqlog_x_errormsg" : bool('reqlog_x_errormsg', true),
    "reqlog_x_useragent" : bool('reqlog_x_useragent', true),
    "reqlog_x_txid" : bool('reqlog_x_txid', true),
    "reqlog_x_custid" : bool('reqlog_x_custid', false),
    "reqlog_x_gtid" : bool('reqlog_x_gtid', true),
    "reqlog_x_mtid" : bool('reqlog_x_mtid', true),
    "reqlog_x_mdepth" : bool('reqlog_x_mdepth', true),
    "reqlog_x_httpc" : bool('reqlog_x_httpc', true),
    "reqlog_x_sql" : bool('reqlog_x_sql', true),
    "reqlog_x_dbc" : bool('reqlog_x_dbc', true),
    "reqlog_x_login" : bool('reqlog_x_login', true),
    "reqlog_x_rs" : bool('reqlog_x_rs', true),

    // Cloud PLATFORM
    "cloud_platform":str('cloud_platform', 'kic'),
    "cloud_platform_chk":str('cloud_platform_chk', 'kr-central-1'),
    "cloud_platform_httpc":str('cloud_platform_httpc', 'http://169.254.169.254/latest/meta-data/placement/availability-zone'),

    "stat_ipurl_enabled": bool("stat_ipurl_enabled", false),
    "stat_ipurl_max_count": num("stat_ipurl_max_count", 10000),

    "grpc_profile_enabled": bool("grpc_profile_enabled", true),
    "grpc_profile_stream_client_enabled": bool("grpc_profile_stream_client_enabled", true),
    "grpc_profile_stream_server_enabled": bool("grpc_profile_stream_server_enabled", true),
    "grpc_profile_ignore_method": bool("grpc_profile_ignore_method", true),

    "oname_port_postfix_enabled": bool("oname_port_postfix_enabled", false),
    "ignore_http_lost_connection": bool("ignore_http_lost_connection", false),

    "profile_graphql_enabled": bool("profile_graphql_enabled", true),
    "profile_graphql_variable_enabled": bool("profile_graphql_variable_enabled", false),
    "ignore_graphql_operation": str("ignore_graphql_operation", ''),

    "prisma_read_func_name": str("prisma_read_func_name", "read"),
    "prisma_database_url_name": str("prisma_database_url_name", "DATABASE_URL"),

    "metering_tagcount_enabled": bool("metering_tagcount_enabled", false),

    "trace_cron_enabled": bool("trace_cron_enabled", false),
    "trace_kafka_enabled": bool("trace_kafka_enabled", false),
    "trace_kafka_consumer_enabled": bool("trace_kafka_consumer_enabled", false)

};

ConfigDefault._hook_method_ignore_prefix = ConfigDefault.hook_method_ignore_prefixes.split(',');
ConfigDefault._hook_method_ignore_prefix_len = ConfigDefault._hook_method_ignore_prefix == null ? 0 : ConfigDefault._hook_method_ignore_prefix.length;

ConfigDefault.hook_method_ignore_classes = ConfigDefault.hook_method_ignore_classes;
ConfigDefault._hook_method_ignore_classes = ConfigDefault.hook_method_ignore_classes.replace('.', '/').split(',');

module.exports = ConfigDefault;