/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

 exports.NULL = 0;
 exports.BOOLEAN = 10;
 exports.DECIMAL = 20;
 exports.DECIMAL_INT = 21;
 exports.FLOAT = 30;
 exports.DOUBLE = 40;
 
 exports.DOUBLE_SUMMARY = 45;
 exports.LONG_SUMMARY = 46;
 
 exports.TEXT = 50;
 exports.TEXT_HASH = 51;
 exports.BLOB = 60;
 exports.IP4ADDR = 61;
 
 exports.LIST = 70;
 
 exports.ARRAY_INT = 71;
 exports.ARRAY_FLOAT = 72;
 exports.ARRAY_TEXT = 73;
 exports.ARRAY_LONG = 74;
 
 exports.MAP = 80;
 exports.INT_MAP = 81;
 exports.METRIC = 82;
 
 var NullValue = require('./null-value'),
     BooleanValue = require('./boolean-value'),
     DecimalValue = require('./decimal-value'),
     IntValue = require('./int-value'),
     FloatValue = require('./float-value'),
     DoubleValue = require('./double-value'),
     TextValue = require('./text-value'),
     TextHashValue = require('./texthash-value'),
     BlobValue = require('./blob-value'),
     IP4Value = require('./ip4-value'),
     ListValue = require('./list-value'),
     MapValue = require('./map-value'),
     IntMapValue = require('./int-map-value'),
     LongSummary = require('./long-summary'),
     DoubleSummary = require('./double-summary'),
     IntArray = require('./int-array'),
     FloatArray = require('./float-array'),
     TextArray = require('./text-array'),
     MetricValue = require('./metric-value'),
     LongArray = require('./long-array');
 
 exports.create = function (code) {
     switch (code) {
         case this.NULL:
             return new NullValue();
         case this.BOOLEAN:
             return new BooleanValue();
         case this.DECIMAL:
             return new DecimalValue();
         case this.DECIMAL_INT:
             return new IntValue();
         case this.FLOAT:
             return new FloatValue();
         case this.DOUBLE:
             return new DoubleValue();
         case this.TEXT:
             return new TextValue();
         case this.TEXT_HASH:
             return new TextHashValue();
         case this.BLOB:
             return new BlobValue();
         case this.IP4ADDR:
             return new IP4Value();
         case this.LIST:
             return new ListValue();
         case this.MAP:
             return new MapValue();
         case this.INT_MAP:
             return new IntMapValue();
         case this.LONG_SUMMARY:
             return new LongSummary();
         case this.DOUBLE_SUMMARY:
             return new DoubleSummary();
         case this.ARRAY_INT:
             return new IntArray();
         case this.ARRAY_FLOAT:
             return new FloatArray();
         case this.ARRAY_TEXT:
             return new TextArray();
         case this.ARRAY_LONG:
             return new LongArray();
         case this.METRIC:
             return new MetricValue();
         default:
             return null;
     }
 };
 