/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Value       = require('./value'),
    ValueEnum   = require('./valueenum'),
    HashUtil    = require('../util/hashutil');

function TextHashValue(value) {
    Value.call(this);
    this.value = value; /*number*/
 
    this.compareTo = function(object) {
        if(object instanceof TextHashValue) {
            return this.value < object.value ? -1 : (this.value === object.value ? 0 : 1);
        }
        return 1;
    };
    this.equals = function(object) {
        if(object instanceof TextHashValue) {
            return this.value === object.value;
        }
        return false;
    };
    this.hashCode = function() {
        return this.value;
    }


}

TextHashValue.prototype = new Value();
TextHashValue.prototype.constructor = TextHashValue;
TextHashValue.prototype.getValueType = function () {
    return ValueEnum.TEXT_HASH;
};
TextHashValue.prototype.write = function(dout) {
    dout.writeInt(this.value);
};
TextHashValue.prototype.read = function(din) {
    this.value = din.readInt();
    return this;
};
TextHashValue.prototype.toObject = function () {
    return this.value;
};

module.exports = TextHashValue;