/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Value       = require('./value'),
    ValueEnum   = require('./valueenum');

function TextArray(value) {
    Value.call(this);
    this._hash = 0;
    this.value = value || [];
   
    this.compareTo = function(object) {
        if(object instanceof TextArray) {
            if(object.value == null && this.value == null) {
                return 0;
            }
            if(this.value == null) {
                return -1;
            }
            if(object.value == null) {
                return 1;
            }
            var l_len = this.length,
                r_len = object.length;
            for(var i=0; i<l_len.length && i < r_len.length; i++) {
                if(this.value[i] > object.value[i]) {
                    return 1;
                }
                if(this.value[i] < object.value[i]) {
                    return -1;
                }
            }
            return l_len - r_len;
        }
        return 1;
    };
    this.equals = function(object) {
        if(object instanceof TextArray) {
            if(object.value == null && this.value == null) {
                return 0;
            }
            if(this.value == null) {
                return -1;
            }
            if(object.value == null) {
                return 1;
            }
            var l_len = this.length,
                r_len = object.length;
            for(var i=0; i<l_len.length && i < r_len.length; i++) {
                if(this.value[i].equals(object.value[i])===false) {
                    return false;
                }
            }
            return l_len - r_len;
        }
        return false;
    };
    this.hashCode = function() {
        if(this._hash == 0) {
            if(this.value == null) {
                return 0;
            }
            var result = 1,
                len = this.value.length;
            for(var j=0; j<len; j++) {
                var element = this.value[j];
                var hashtmp = 0,
                    i, chr, len;
                if (element.length === 0) {
                    hashtmp = 0;
                } else {
                    for (i = 0, len = element.length; i < len; i++) {
                        chr   = element.charCodeAt(i);
                        hashtmp  = ((hashtmp << 5) - hashtmp) + chr;
                        hashtmp |= 0; // Convert to 32bit integer
                    }
                }
                result = 31 * result + hashtmp;
            }
            this._hash = result;
        }
        return this._hash;
    };
}

TextArray.prototype = new Value();
TextArray.prototype.constructor = TextArray;
TextArray.prototype.write = function(dout) {
    if(this.value == null) {
        dout.writeShort(0);
    } else {
        var len = this.value.length;
        dout.writeShort(len);
        for(var i=0; i<len; i++) {
            dout.writeText(this.value[i]);
        }
    }
};
TextArray.prototype.read = function(din) {
    var length = din.readShort();
    this.value = new Array(length);
    for(var i=0; i<length; i++) {
        this.value[i] = din.readText();
    }
    return this;
};
TextArray.prototype.getValueType = function () {
    return ValueEnum.ARRAY_TEXT;
};
TextArray.prototype.toObject = function () {
    return this.value;
};

module.exports = TextArray;