/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */


//var LongKeyLinkedMap   = require('./longkey-linkedmap');
var LinkedMap   = require('./linkedmap'),
    Long        = require('long');


function LongIntLinkedMap(initCapacity, loadFactor) {
    LinkedMap.call(this, initCapacity, loadFactor);
    return this;
}
LongIntLinkedMap.prototype = new LinkedMap();
LongIntLinkedMap.prototype.constructor = LongIntLinkedMap;
// LongIntLinkedMap.prototype.add = function (key, value) {
//     var val = LongKeyLinkedMap.prototype.get.call(this, key)
//     LongKeyLinkedMap.prototype.put.call(val.add(value));
// };
LongIntLinkedMap.prototype.none = function () {
    return 0;
};
LongIntLinkedMap.prototype.hash = function (key /*long*/) {
    return Math.abs(key.toNumber());
};
LongIntLinkedMap.prototype.equals = function (key1, key2) {
    return key1.equals(key2);
};
LongIntLinkedMap.prototype.sum = function (value1, value2) {
    return value1+value2;
};

module.exports = LongIntLinkedMap;