/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var LinkedMap   = require('./linkedmap');

function IntSet(initCapacity, loadFactor) {
    LinkedMap.call(this, initCapacity, loadFactor);
}

IntSet.prototype = new LinkedMap();
IntSet.prototype.constructor = IntSet;

IntSet.prototype.none = function () {
    return 0;
};
IntSet.prototype.hash = function (key /*int*/) {
    return Math.abs(key);
};
IntSet.prototype.equals = function (key1, key2) {
    return key1===key2;
};
IntSet.prototype.sum = function (value1, value2) {
    return value1+value2;
};

IntSet.prototype.add = function (key) {
    return this._put(key, key, LinkedMap.MODE.LAST);
};
IntSet.prototype.put = function (key) {
    return this._put(key, key, LinkedMap.MODE.LAST);
};
IntSet.prototype.putLast = function (key) {
    return this._put(key, key, LinkedMap.MODE.FORCE_LAST);
};
IntSet.prototype.putFirst = function (key) {
    return this._put(key, key, LinkedMap.MODE.FORCE_FIRST);
};

IntSet.prototype.hasKey = function (key) {
    return this.containsKey(key);
};
IntSet.prototype.forEach=function(f){
    var en = this.keys();
    while(en.hasMoreElements()) {
        var e = en.nextElement();
        f(e);
    }
}
IntSet.prototype.toBytes = function (dout) {
    dout.writeDecimal(this.size());
    var en = this.keys();
    while(en.hasMoreElements()) {
        var e = en.nextElement();
        dout.writeDecimal(e);
    }
};
IntSet.prototype.toObject = function (din) {
    var cnt = din.readDecNumber();
    for (var i = 0; i < cnt; i++) {
        var key = din.readDecNumber();
        this.put(key);
    }
    return this;
};
IntSet.prototype.toString = function () {
    var str = '';
    var it = this.entries();
    str += '{';
    for(var i=0; it.hasMoreElements(); i++) {
        var e = it.nextElement();
        if(i > 0) {
            str += ", ";
        }
        str += e.getKey();
    }
    str += "}";
    return str;
};

module.exports = IntSet;