/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */


var NodeUtil = require('../util/nodeutil');
var http = require('http');
var Configure   = require('../conf/configure'),
    Logger      = require('../logger');
var emptyIp = Buffer.alloc(4 , 0);

function getIPAddresses() {

    var ipAddresses = [];
    var interfaces = require('os').networkInterfaces();
    for (var devName in interfaces) {
        var iface = interfaces[devName];
        for (var i = 0; i < iface.length; i++) {
            var alias = iface[i];
            if (alias.family === 'IPv4' && alias.address !== '127.0.0.1' && !alias.internal) {
                ipAddresses.push(alias.address);
            }
        }
    }
    return ipAddresses;
}
function getRandomInteger(min, max) {
    min = Math.ceil(min);
    max = Math.floor(max);
    return Math.floor(Math.random() * (max - min)) + min;
}
function printWhatap() {
    var str =
        ' _      ____       ______NODE-AGENT  '     + (Configure.whatap_micro_enabled === true || process.env.WHATAP_MICRO_ENABLED === "true" ? "\t\t\t| |        | |                        | |           " : '')+ '\n'+
        '| | /| / / /  ___ /_  __/__ ____' + ''     + (Configure.whatap_micro_enabled === true || process.env.WHATAP_MICRO_ENABLED === "true" ? "\t\t\t| | ___   _| |__   ___ _ __ _ __   ___| |_ ___  ___ " : '')+ '\n'+
        '| |/ |/ / _ \\/ _ `// / / _ `/ _ \\' + ''  + (Configure.whatap_micro_enabled === true || process.env.WHATAP_MICRO_ENABLED === "true" ? "\t\t\t| |/ / | | | '_ \\ / _ \\ '__| '_ \\ / _ \\ __/ _ \\/ __|" : '')+ '\n'+
        '|__/|__/_//_/\\_,_//_/  \\_,_/ .__/' + ''  + (Configure.whatap_micro_enabled === true || process.env.WHATAP_MICRO_ENABLED === "true" ? "\t\t\t|   <| |_| | |_) |  __/ |  | | | |  __/ ||  __/\\__ \\" : '')+ '\n'+
        '                          /_/      ' + ''        + (Configure.whatap_micro_enabled === true || process.env.WHATAP_MICRO_ENABLED === "true" ? "\t\t\t|_|\\_\\\\__,_|_.__/ \\___|_|  |_| |_|\\___|\\__\\___||___/" : '')+ '\n'+
        'Just Tap, Always Monitoring' + '\n'+
        'WhaTap Node Agent version ' + NodeUtil.getVersion() + ', ' + NodeUtil.getReleaseDate();
    console.log(str);
}

function cloudPlatformCheck() {
    let cloud_platform = Configure.cloud_platform;
    let cloud_platform_chk = Configure.cloud_platform_chk;
    let cloud_platform_httpc = Configure.cloud_platform_httpc;
    let CAP_INFO = '';
    Logger.print('[cloudPlatformCheck]', `cloud_platform: ${cloud_platform} , cloud_platform_chk: ${cloud_platform_chk} , cloud_platform_httpc: ${cloud_platform_httpc}` , false)
    http.get(cloud_platform_httpc, (resp) => {
        let data = '';
        
        resp.on('data', (chunk) => {
            data += chunk;
        });

        resp.on('end', () => {
            if (data.length < 5) return;
            if (data.indexOf(cloud_platform_chk) >= 0) {
                Logger.print('[cloudPlatformCheck]', "This agent is working in " + cloud_platform , false)
                CAP_INFO = cloud_platform;
            }
            return CAP_INFO;
        });
    }).on("error", (err) => {
        Logger.print('[cloudPlatformCheck Error]', "Error: " + err.message , false);
    });
    return CAP_INFO;
}

module.exports = {
    getIPAddresses: getIPAddresses,
    getRandomInteger: getRandomInteger,
    printWhatap: printWhatap,
    cloudPlatformCheck:cloudPlatformCheck
};
