/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Long = require('long');

var Hexa32 = function(){
};

Hexa32.toString32 = function(num /* long */){
    if(num===undefined || num === null){
       return '0';
    }
    
    var minus = num < 0 ;
    if(minus){
        if(num === Long.MIN_VALUE ){
            return min;
        }
        if(typeof num === 'number'){
           num=-num;
        }else{
           num=num.multiply(-1);
        }
        return MINUS + num.toString(32);
    } else{
        if(num < 10){
            return num+'';
        }else{
            return PLUS + num.toString(32);
        }
    }
};

Hexa32.toLong32 = function(str /* String */){
    if(str == null || str.length === 0) return Long.ZERO;

    switch(str[0]){
        case MINUS:
            return Long.fromString( str.substring(1), false, 32).neg() ;
        case PLUS:
            return Long.fromString( str.substring(1), false, 32) ;
        default:
            return Long.fromString(str);
    }
};
Hexa32.toNumber32 = function(str){
    var v = Hexa32.toLong32(str);
    return v.toNumber();
};
var PLUS = Hexa32.PLUS = 'x';
var MINUS = Hexa32.MINUS = 'z';
var min = Hexa32.min = "z8000000000000";

module.exports = Hexa32;
