/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Value       = require('./value'),
    ValueEnum   = require('./valueenum'),
    ArrayUtil   = require('../util/array-util');

function FloatArray(value) {
    Value.call(this);
    this.value = value || [];
    this._hash = 0;

    this.compareTo = function(object) {
        if(object instanceof FloatArray) {
            return ArrayUtil.compare(this.value, object.value);
        }
        return 1;
    };
    this.equals = function(object) {
        if(object instanceof  FloatArray) {
            return ArrayUtil.equals(this.value, object.value);
        }
        return false;
    };
    this.hashCode = function() {
        if(this._hash === 0) {
            if(this.value == null) {
                return 0;
            }
            var result = 1,
                len = this.value.length;
            for(var i=0; i<len; i++) {
                var element = this.value[i];
                result = 31 * result + Float.round(element);
            }
        }
        return this._hash;
    }

}
FloatArray.prototype = new Value();
FloatArray.prototype.constructor = FloatArray;
FloatArray.prototype.write = function(dout) {
    dout.writeFloatArray(this.value);
};
FloatArray.prototype.read = function(din) {
    this.value = din.readFloatArray();
    return this;
};
FloatArray.prototype.getValueType = function(){
    return ValueEnum.ARRAY_FLOAT;
};
FloatArray.prototype.toObject = function() {
    return this.value;
};

module.exports = FloatArray;