/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var ValueEnum   = require('./valueenum'),
    Value       = require('./value');

function BooleanValue(value){
    Value.call(this);
    this.value =  value || false;
    this.compareTo = function(object) {
        if(object instanceof BooleanValue) {
            if(this.value === object.value) {
                return 0;
            }
            return this.value ? 1 : -1;
        }
        return 1;
    };
    this.equals = function(object) {
        if(object instanceof BooleanValue) {
            return this.value === object.value;
        }
        return false;
    };
    this.hashCode = function(){
        return this.value ? 1 : 0;
    };

    this.toString = function(){
        return this.value ? 'true' : 'false';
    };
}
BooleanValue.prototype = new Value();
BooleanValue.prototype.constructor = BooleanValue;
BooleanValue.prototype.write = function(dout) {
    dout.writeBoolean(this.value);
};
BooleanValue.prototype.read = function(din) {
    this.value = din.readBoolean();
    return this;
};
BooleanValue.prototype.getValueType = function() {
    return ValueEnum.BOOLEAN;
};
BooleanValue.prototype.toObject = function() {
    return this.value;
};

module.exports = BooleanValue;