/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */


function Utils(){
}
Utils.toUTF8 = function (str) {
    if(typeof str !== 'string') {
        return str;
    }
    var utf8 = [];
    for (var i=0; i < str.length; i++) {
        var charcode = str.charCodeAt(i);
        if (charcode < 0x80) utf8.push(charcode);
        else if (charcode < 0x800) {
            utf8.push(0xc0 | (charcode >> 6),
                0x80 | (charcode & 0x3f));
        }
        else if (charcode < 0xd800 || charcode >= 0xe000) {
            utf8.push(0xe0 | (charcode >> 12),
                0x80 | ((charcode>>6) & 0x3f),
                0x80 | (charcode & 0x3f));
        }
        else {
            utf8.push(0xef, 0xbf, 0xbd);
        }
    }
    return utf8;
};

function ArrayUtil(){

}
ArrayUtil.isExist = function(arr, key){
    if(arr===null || arr === undefined) return false;

    for(var i = 0 ; i < arr.length; i++){
        if(arr[i] === key) return true;
    }
    return false;
};
ArrayUtil.compare = function(v1, v2){
    if(Array.isArray(v1)===false){
        return -1;
    }
    if(Array.isArray(v2)===false){
        return 1;
    }
    
    var l_len = v1.length,
        r_len = v2.length;
    for(var i=0; i<l_len && i < r_len; i++) {
        if(v1[i] > v2[i]) {
            return 1;
        }
        if(v1[i] < v2[i]) {
            return -1;
        }
    }
    return l_len - r_len;
}
            
Utils.Array = ArrayUtil;

module.exports = Utils;