/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var LinkedList = require('./linkedlist');
var RequestDoubleQueue = function(capacity1, capacity2){
    this.capacity1 = capacity1;
    this.capacity2 = capacity2;
    this.queue1 = new LinkedList();
    this.queue2 = new LinkedList();
};
RequestDoubleQueue.prototype.size=function(){
    return {q1:this.queue1.size(), q2:this.queue2.size()};
} 

RequestDoubleQueue.prototype.get = function(){
    if(this.queue1.size() > 0 ){
        return this.queue1.removeFirst();
    }

    if(this.queue2.size() > 0){
        return this.queue2.removeFirst();
    }
    return null;
};
RequestDoubleQueue.prototype.hasNext = function(){
    if(this.queue1.hasNext() ||  this.queue2.hasNext()) return true;
    return false;
};
RequestDoubleQueue.prototype.putForce1 = function(o) {
    return this.putForce(this.queue1, this.capacity1, o);
};
RequestDoubleQueue.prototype.putForce2 = function(o) {
    return this.putForce(this.queue2, this.capacity2, o);
};
RequestDoubleQueue.prototype.putForce = function(q /* LinkedList */, sz /* int */, o ) {
    if(sz <= 0 || q.size() < this.capacity1){
        q.add(o);
        return true;
    }else{
        while (q.size() >= sz){
            var v = q.removeFirst();
            overflowed(v);
        }
        q.add(o);
        return false;
    }
};
RequestDoubleQueue.prototype.put = function(q /* LinkedList */, capacity /* int */, o ) {
    if(capacity <= 0 || q.size() < capacity){
        q.add(o);
        return true;
    }else{
        failed(o);
        return false;
    }
};
RequestDoubleQueue.prototype.put1 = function(o) {
    return this.put(this.queue1, this.capacity1, o);
};
RequestDoubleQueue.prototype.put2 = function(o) {
    return this.put(this.queue2, this.capacity2, o);
};
var failed = function(v /* object */) {
};
var overflowed = function(v /* object */) {
};

module.exports = RequestDoubleQueue;

