/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var LinkedList = require('./linkedlist');

function RequestQueue(capacity) {
    this.capacity = capacity;
    this.queue = new LinkedList();
}

RequestQueue.prototype.get = function () {
    if(this.queue.size() > 0) {
        return this.queue.removeFirst();
    }
    return null;
};
RequestQueue.prototype.getByTimeout = async function (timeout) {
    try{
        if (this.queue.size() > 0) {
            return this.queue.removeFirst()
        }
        var timeto = Date.now() + timeout;
        var time = timeout;
        while (this.queue.size() === 0) {
            try {
                if (time > 0) {
                    await new Promise(resolve => setTimeout(resolve, time));
                }
            } catch (e) {
            }
            time = timeto - Date.now();
            if (time <= 0) {
                break;
            }
        }
        if (this.queue.size() > 0) {
            return this.queue.removeFirst();
        }
        return null;
    }catch (e) {
        return null;
    }
};
RequestQueue.prototype.put = function (o) {
    if(this.capacity <= 0 || this.queue.size() < this.capacity) {
        this.queue.add(o);
        return true;
    } else {
        failed(o);
        return false;
    }
};
RequestQueue.prototype.size = function () {
    return this.queue.size();
};
RequestQueue.prototype.clear = function () {
    this.queue = new LinkedList();
};

var failed = function (v) {

};
var overflowed = function (v) {

};

module.exports = RequestQueue;