/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var MapValue = require('./../value/map-value')

module.exports = {
    readProperty: function(str, spliter, type){
        var result = undefined;
        if(type && type.constructor === MapValue){
            result = new MapValue();
        }else{
            result = {};
        }

        if(str.constructor === String){
            var rowProps = str.split('\n');

            for(var i = 0 ; i < rowProps.length; i++){
                if(rowProps.indexOf('#') === 0 ) continue;

                var p = rowProps[i].split(spliter);
                if(p.length > 1){
                    if(result.constructor === MapValue){
                        result.put(p[0], p[1]);
                    }else{
                        result[p[0]] = p[1];
                    }
                }
            }
        }
        return result;
    }
};