/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

 var fs = require('fs'),
 path = require('path'),
 hahsUtil = require('../util/hashutil2'),
 IPUtil      = require('../util/iputil');
function isLiveProcess(pid) {
if(!pid || pid.length === 0) return true;

try {
 return process.kill(pid,0)
}
catch (e) {
 return e.code === 'EPERM'
}
}

function LockCompetition(key){
 this.MAIN_KEY = key;
 var Configuration = require('./../conf/configure');
 var root = Configuration['app.root'];
 var cwd = process.cwd();
 if(root == undefined) {
	 root = cwd;
 }
 let gubun = hahsUtil.hash(IPUtil.getIp());
 this.rootFolder = path.join(root,'SSwhatapSS').replace('SSwhatapSS',path.sep + '.'+key);
 if(fs.existsSync(this.rootFolder) == false) {
	fs.mkdirSync(this.rootFolder);
 }
 this.rootFolder += path.sep + gubun;
 if(fs.existsSync(this.rootFolder) == false) {
	fs.mkdirSync(this.rootFolder);
 }
 this.LOCK_FILE = path.join(this.rootFolder,this.MAIN_KEY+'.lock');
 this.initComplete = false;
}

LockCompetition.prototype.init = function(cb){
 if(this.initComplete) {
	 if(cb) cb();
 }
 fs.mkdir( this.rootFolder, function(err){
	 if(!err || err.code === 'EEXIST'){
		 this.initComplete = true;
		 if(cb) cb();
	 }else{
		 return console.error(err);
	 }
 });
}

LockCompetition.prototype.accessAuth = function(cb){
 var self = this;		
 self.init(function(){
	 var i = setInterval(function(){
		 self.createLockFile(path.join(self.LOCK_FILE), function(result){
			 if(result){
				 self.checkFileIndex(1, function(idx){
					 self.releaseLockFile( function(result){
						 if(result){
							 cb(idx);		
							 clearInterval(i);
						 }
					 })
				 })
			 }
		 })
	 },10)
 });
}

LockCompetition.prototype.readLockFile = function(cb){
 fs.readFile( this.LOCK_FILE, 'utf-8', function(err,data){
	 if(cb) cb(err, data);
 });
}

LockCompetition.prototype.createLockFile = function(file, cb){
 var self = this;
 self.readLockFile(function(err, data){
	 if(err){
		 fs.writeFile(file, process.pid + '', 'utf-8', function(err,data){
			 if(err){
				 if(cb) return cb(false);
			 }else{
				 self.readLockFile( function(err, data){
					 if(err && cb) return cb(false);
					 if(parseInt(data) === process.pid){
						 if(cb) return cb(true);
					 }else{
						 if(cb) return cb(false);
					 }
				 });
			 }
		 });
	 }else{
		 if(isLiveProcess(data)){
			 if(cb) return cb(false);
		 }else{
			 fs.unlink(self.LOCK_FILE, function(err){
				 if(err){
					 if(cb) return cb(false);
				 }else{
					 if(cb) return cb(true);
				 }
			 });
		 }
	 }
 });
}

LockCompetition.prototype.releaseLockFile = function(cb){
 var self = this;
 fs.readFile(self.LOCK_FILE, 'utf-8', function(err,data){
	 if(err && cb) return cb(err, data);

	 if(parseInt(data) === process.pid){
		 fs.unlink(self.LOCK_FILE, function(err){
			 if(err){
				 if(cb) return cb(false);
			 }else{
				 if(cb) return cb(true);
			 }
		 });
	 }else{
		 if(cb) return cb(false);
	 }
 });
}

LockCompetition.prototype.checkFileIndex = function(idx,cb){
 var self = this;
 idx = idx || 1;
 fs.readFile(path.join(self.rootFolder, self.MAIN_KEY+idx), 'utf-8', function(err,data){
	 if(err){
		 fs.writeFile(path.join(self.rootFolder, self.MAIN_KEY+idx), process.pid + '', 'utf-8', function(err){
			 if(err){
				 self.checkFileIndex(++idx,cb);					
			 }else{
				 if(cb) cb(idx);
			 }
		 });
	 }else{
		 if( isLiveProcess(data) ){
			 self.checkFileIndex(++idx,cb);
		 }else{
			 fs.writeFile(path.join(self.rootFolder, self.MAIN_KEY+idx), process.pid + '', 'utf-8', function(result){
				 if(err){
					 self.checkFileIndex(++idx,cb);
				 }else{
					 if(cb) cb(idx);
				 }
			 });
		 }
	 }
 })
}

module.exports = function(key){
 return new LockCompetition(key);
};