
var KeyGen  = require('./keygen'),
    conf    = require('../conf/configure'),
    fs      = require('fs'),
    path    = require('path');
var Buffer  = require('buffer').Buffer;

var ParamSecurity = function () {
    this.key = null;
    this.reload();
};

ParamSecurity.prototype.getKey = function () {
    var s = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    var buf = '';
    for(var i=0; i<6; i++) {
        var x = Math.abs(parseInt(KeyGen.next() % s.length));
        buf += s.charAt(x);
    }
    return buf;
};

ParamSecurity.prototype.reload = function () {
    var home = conf['app.root'];
    if (home == null ) {
        var self = this;
        setTimeout(function () {
            self.reload();
        }, 5000);
        return;
    }

    var file = path.join(home, 'security.conf');
    var self = this;
    try {
        var stat = fs.statSync(file);
        if(stat.size != 6) {
            self.key = Buffer.from("WHATAP");
            return;
        }
        var readable = fs.createReadStream(file, {flags : 'r'});
        readable.on('readable', function () {
            if(self.key !== null
                && self.key !== undefined
                && self.key.length === 0 ) { return; }
            var chunk;
            while (null !== (chunk = readable.read())) {
                self.key = chunk;
            }
            self.key = Buffer.from(self.key);
        });
    } catch (e) {
        // self.key = self.getKey();
        self.key = 'WHATAP';
        var printWriter = fs.createWriteStream(file, {flags : 'w'});
        printWriter.write(self.key);
        self.key = Buffer.from(self.key);
    }
};
ParamSecurity.prototype.encrypt = function (b, crc) {
    var self = this;
    if(self.key == null || self.key.length === 0) {
        self.reload();
        return null;
    }
    for(var i=0, j=0; i<b.length; i++, j = (j + 1) % self.key.length) {
        crc.value ^= b[i];
        b[i] ^= self.key[j];
    }

    return b;
};
ParamSecurity.prototype.decrypt = function (b, crc, dkey) {
    for(var i=0, j=0; i<b.length; i++, j = (j+1) % dkey.length) {
        b[i] ^= dkey[j];
        crc.value ^= b[i];
    }
    return b;
};
module.exports = new ParamSecurity();