var fs = require('fs');
var HashUtil2    = require('./hashutil2'),
    StringUtil  = require('./string-util'),
    Logger      = require('./../logger');

var KubeUtil = {
    container_key: 0, 
    container_id: undefined,
    loadFromMountinfo: function() {
        if (this.container_id) return;

        try{
            var content = fs.readFileSync("/proc/self/mountinfo");
            content = content.toString('utf-8');
            var contents = content.split('\n')

            for(var i = 0 ; i < contents.length ; i++){
                var line = contents[i].trim();
                if(line){
                    if(line.indexOf("/kubelet/pods/") >= 0) {
                        let lineParts = line.split("/kubelet/pods/");
                        if (lineParts != null && lineParts.length > 1) {
                            this.container_id= lineParts[1].split('/')[0];
                        }
                        if(this.container_id.length > 5){
                            this.container_key = HashUtil2.hash(this.container_id);
                            break;
                        }
                    }
                }
            }
            Logger.print('WHATAP-800' , 'loadFromMountinfo id:' + this.container_id + ' // key:' + this.container_key  , false)
        }catch(e){
            Logger.printError('WHATAP-800', 'KubeUtil(loadFromMountinfo) ', e)
        }
    },
    loadContainerId: function(){
        if (this.container_id) return;

        try{
            var content = fs.readFileSync("/proc/self/cgroup");
            content = content.toString('utf-8');
            var contents = content.split('\n')

            for(var i = 0 ; i < contents.length ; i++){
                var line = contents[i].trim();
                if(line){
                    if(line.indexOf("/ecs/") >= 0) {
                        this.container_id = line.substr(line.lastIndexOf('/')+1) || '';
                      } else{
                        //this.container_id = line.substr(line.lastIndexOf('/')+1) || '';
                        //this.container_id = this.container_id.replace(/^(docker-)+|(cri-containerd-)+|(crio-)+|(\\.scope)+$/ig, "");
                        //container_id = container_id.replace(/^(docker-)+|(cri-)+|(cri-containerd-)+|(crio-)+|(.scope)+$/ig, "");
                        this.container_id = line.substr(line.lastIndexOf('/')+1) || '';
                        this.container_id = this.container_id.replace(/^|(.scope)+$/ig, "");
                        this.container_id = this.container_id.substr(this.container_id.lastIndexOf('-')+1);
                        this.container_id = this.container_id.substr(this.container_id.lastIndexOf(':')+1);
                      }

                    if(this.container_id.length > 5){
                        this.container_key = HashUtil2.hash(this.container_id);
                        break;
                    }
                }
            }
            Logger.print('WHATAP-800' , 'loadContainerId id:' + this.container_id + ' // key:' + this.container_key  , false);
        }catch(e){
            Logger.printError('WHATAP-800', 'KubeUtil(loadContainerId) ', e)
        }
        if(!this.container_key) this.loadFromMountinfo();
    }
}
module.exports = KubeUtil;