/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var LinkedMap = require('./linkedmap');

function IntKeyMap(initCapacity, loadFactor) {
    LinkedMap.call(this, initCapacity, loadFactor);
}

IntKeyMap.prototype = new LinkedMap();
IntKeyMap.prototype.constructor = IntKeyMap;
IntKeyMap.prototype.create = function () {throw new Error("create method not implemented!!")};

IntKeyMap.prototype.hash = function (key /*int*/) {
    return Math.abs(key);
};
IntKeyMap.prototype.equals = function (key1, key2) {
    return key1===key2;
};
IntKeyMap.prototype.sum = function (value1, value2) {
    return value1+value2;
};
module.exports = IntKeyMap;