/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Step = require('../step/step');

function ErrorData(error, dbc, service, profile, isStackTrace) {
    this.error = error || {};
    this.dbc = dbc || 0;
    this.service = service || 0;
    this.profile = profile || new Step();
    this.isStackTrace = isStackTrace || null;
}

ErrorData.prototype.toString = function() {
    return "LeakData [error=" + this.error + ", dbc=" + this.dbc + ", service=" + this.service + ", profile=" + this.profile + "]";
};

module.exports = ErrorData;