/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var DateTimeHelper = require('./datetimehelper');

module.exports = MILLIS_PER_SECOND = 1000;
module.exports = MILLIS_PER_MINUTE = 60 * MILLIS_PER_SECOND;
module.exports = MILLIS_PER_FIVE_MINUTE = 5 * 60 * MILLIS_PER_SECOND;
module.exports = MILLIS_PER_TEN_MINUTE = 10 * MILLIS_PER_MINUTE;
module.exports = MILLIS_PER_HOUR = 60 * MILLIS_PER_MINUTE;
module.exports = MILLIS_PER_DAY = 24 * MILLIS_PER_HOUR;
module.exports = SECONDS_PER_DAY = parseInt(MILLIS_PER_DAY / 1000);


function datetime(time){
    // return helper.datetime(time);
}

var delta;
var currentTime = function () {};
var datetime = function (time) {
    return this.helper.datetime(time);
};
var yyyymmdd = function (time) {
    return this.helper.yyyymmdd((time || Date.now()));
};
var yyyymmddhh = function (time) {
    return this.helper.yyyymmddhh(Date.now());
};
var currentTime = function(){
    if(delta) {
        return Date.now() + delta;
    } else {
        return Date.now();
    }
};
var setServerTime = function(time , syncfactor){
    var now = Date.now();
    delta = time - now;
    if(delta != 0 ){
        delta = delta * syncfactor;
    }
    return delta;
};
var getDateUnit = function (time) {
    if(time == null || time === NaN) {
        time = this.currentTime();
    }
    return this.helper.getDateUnit(time);
};

var getMonth = function (time, delta) {
    return this.helper.getMonth(time, delta);
};

function timeListen(crons, loop, cb){
    if(!loop) loop = false;

    var cron = crons.split(' ');
    var years = cron[0].split(',');
    var months = cron[1].split(',');
    var days = cron[2].split(',');
    var hours = cron[3].split(',');
    var minutes = cron[4].split(',');
    var seconds = cron[5].split(',');
    var intervalIndex = setInterval(function(){
        var isCheck = false;
        var d = new Date();
        var ss = d.getSeconds()
        if(seconds.length > 0 ){
            for(var i = 0 ; i < seconds.length; i++){
                var second = seconds[i];
                if( ss % second === 0){
                    isCheck = true; break;
                }
            }
        }

        if(isCheck === true && cb) {
            cb();
            if(loop === false){
                clearInterval(intervalIndex);
            }
        }
    }, 100);
}

var DateUtil = {
    helper       : new DateTimeHelper(),
    currentTime  : currentTime,
    datetime     : datetime,
    setServerTime: setServerTime,
    yyyymmdd     : yyyymmdd,
    yyyymmddhh     : yyyymmddhh,
    getDateUnit  : getDateUnit,
    timeListen: timeListen,
    getMonth : getMonth
};

module.exports = DateUtil;
module.exports.MILLIS_PER_SECOND = MILLIS_PER_SECOND;
module.exports.MILLIS_PER_MINUTE = MILLIS_PER_MINUTE;
module.exports.MILLIS_PER_FIVE_MINUTE = MILLIS_PER_FIVE_MINUTE;
module.exports.MILLIS_PER_TEN_MINUTE = MILLIS_PER_TEN_MINUTE;
module.exports.MILLIS_PER_HOUR = MILLIS_PER_HOUR;
module.exports.MILLIS_PER_DAY = MILLIS_PER_DAY;
module.exports.SECONDS_PER_DAY = SECONDS_PER_DAY;
