/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Long = require('long');

function hash(data) {
    var m = 0x5bd1e995;
    var r = 24;
    var h = 0;
    var k = data.mul(m);
    k = k.getLowBits();
    k ^= k >>> r;
    h ^= Long.fromNumber(k).mul(m).getLowBits();
    k =  Long.fromNumber(data.getHighBits()).mul(m).getLowBits();
    k ^= k >>> r;
    h = Long.fromNumber(h).mul(m).getLowBits();
    h ^= Long.fromNumber(k).mul(m).getLowBits();
    h ^= h >>> 13;
    h = Long.fromNumber(h).mul(m).getLowBits();
    h ^= h >>> 15;
    return h;
};

var MurMurHash = {
    hashLong : hash
};

module.exports = MurMurHash;
