var INT = 1;
var LONG = 2;
var FLOAT = 3;
var DOUBLE = 4;
var STRING = 5;

AnyList.INT = 1;
AnyList.LONG = 2;
AnyList.FLOAT = 3;
AnyList.DOUBLE = 4;
AnyList.STRING = 5;

function AnyList(type, len){
    this.type=type;
    this.data = new Array(len);
}
AnyList.prototype.getType=function(){
    return this.type;
};
AnyList.prototype.put=function(idx, d){
    this.data[idx]=d;
};

AnyList.prototype.get=function(idx){
    return this.data[idx];
};
AnyList.prototype.size = function () {
    return this.data ? this.data.length : 0;
};
AnyList.prototype.write=function(o){
     switch(this.type){
        case INT: this.writeDecimal(o);  return  this;
        case LONG: this.writeDecimal(o);  return  this; 
        case FLOAT: this.writeFloat(o);  return  this;
        case DOUBLE: this.writeDouble(o);  return  this;
        case STRING: this.writeString(o); return  this;
     }
};
AnyList.prototype.read=function(i){
    switch(this.type){
       case INT: this.readDecimal(i);  return  this;
       case LONG: this.readDecimal(i);  return  this; 
       case FLOAT: this.readFloat(i);  return  this;
       case DOUBLE: this.readDouble(i);  return  this;
       case STRING: this.readString(i); return  this;
    }
};

AnyList.prototype.writeDouble = function (dout) {
    var len =this.size();
    dout.writeInt24BE(len);
    for (var i = 0; i < len; i++) {
        dout.writeDouble(this.get(i));
    }
};
AnyList.prototype.readDouble=function(din) {
    var count = din.readInt24BE();
    for (var i = 0; i < count; i++) {
        this.add(din.readDouble());
    }
};
AnyList.prototype.writeFloat = function (dout) {
    var len =this.size();
    dout.writeInt24BE(len);
    for (var i = 0; i < len; i++) {
        dout.writeFloat(this.get(i));
    }
};
AnyList.prototype.readFloat=function(din) {
    var count = din.readInt24BE();
    for (var i = 0; i < count; i++) {
        this.add(din.readFloat());
    }
};

AnyList.prototype.writeDecimal = function (dout) {
    var len =this.size();
    dout.writeInt24BE(len);
    for (var i = 0; i < len; i++) {
        dout.writeDecimal(this.get(i));
    }
};
AnyList.prototype.readDecimal=function(din) {
    var count = din.readInt24BE();
    for (var i = 0; i < count; i++) {
        this.add(din.readDecNumber());
    }
};
AnyList.prototype.writeString = function (dout) {
    var len =this.size();
    dout.writeInt24BE(len);
    for (var i = 0; i < len; i++) {
        dout.writeText(this.get(i));
    }
};
AnyList.prototype.readString=function(din) {
    var count = din.readInt24BE();
    for (var i = 0; i < count; i++) {
        this.add(din.readText());
    }
};

module.exports = AnyList;