const   SqlStepX        = require('../step/sql-stepx'),
    conf            = require('../conf/configure'),
    StatError       = require('../stat/stat-error'),
    TextTypes       = require("../lang/text-types");

var TraceSql = function () {}

TraceSql.prototype.hasSqlStepX = function (buffer) {
    if (!Array.isArray(buffer)) {
        return [];
    }

    return buffer.filter(item => item instanceof SqlStepX);
}

TraceSql.prototype.isSlowSQL = function (ctx) {
    if(!ctx.profile.buffer)
        return;

    var profile_error_sql_time_max = conf.getProperty('profile_error_sql_time_max', 30000);
    var sqlStepX = this.hasSqlStepX(ctx.profile.buffer);
    var slow_sql_step = sqlStepX.find(step => step.elapsed > profile_error_sql_time_max);
    if(slow_sql_step){
        slow_sql_step.error = StatError.addError('SLOW_SQL', 'SLOW SQL', ctx.service_hash, TextTypes.SQL, null);
        if(ctx.error.isZero()){
            ctx.error = slow_sql_step.error;
        }
    }
    return;
}

TraceSql.prototype.isTooManyRecords = function (sql_step, rs_count, ctx) {
    if(!ctx.profile.buffer)
        return;

    var profile_error_sql_fetch_max = conf.getProperty('profile_error_sql_fetch_max', 10000);
    if(rs_count && rs_count > profile_error_sql_fetch_max){
        sql_step.error = StatError.addError('TOO_MANY_RECORDS', 'Too many records', ctx.service_hash, TextTypes.SQL, null)
        if(ctx.error.isZero()){
            ctx.error = sql_step.error;
        }
    }
}

module.exports = new TraceSql();