const   HttpStepX = require('../step/http-stepx'),
        conf = require('../conf/configure'),
        StatError= require('../stat/stat-error'),
        TextTypes= require("../lang/text-types");

var TraceHttpc = function () {}

TraceHttpc.prototype.hasHttpStepX = function (buffer) {
    if (!Array.isArray(buffer)) {
        return [];
    }

    return buffer.filter(item => item instanceof HttpStepX);
}

TraceHttpc.prototype.isSlowHttpc = function (ctx, httpc_step) {
    if(!ctx.profile.buffer)
        return;
    var profile_error_httpc_time_max = conf.getProperty('profile_error_httpc_time_max', 10000);

    if(httpc_step.elapsed && (httpc_step.elapsed > profile_error_httpc_time_max)){
        httpc_step.error = StatError.addError('SLOW_HTTPC', 'SLOW HTTPC', ctx.service_hash, TextTypes.HTTPC_URL, null);
    }
}

module.exports = new TraceHttpc();