/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var ProfileCollector    = require('./profile-collector'),
    IntKeyMap           = require('../util/intkey-map'),
    KeyGen              = require('../util/keygen'),
    StringKeyLinkedMap   = require('../util/stringkey-linkedmap');
    Hexa32              = require('../util/hexa32'),
    Logger              = require('../logger'),
    Long                = require('long');

function TraceContext(id) {
    this._id = id;
    this.isStaticContents = false;
    this.profile = new ProfileCollector(this);

    this.txid = KeyGen.next();
    this.thread = null;
    this.thread_id = 0;

    this.start_cpu = 0;
    this.start_malloc = 0;
    this.start_time = 0;

    this.status = 0;

    this.service_hash = 0;
    this.service_name = '';
    this.remoteIp = 0;
    this.error = Long.ZERO;

    this.http_method = '';
    this.http_query = '';
    this.http_content_type = '';
   
    this.sql_count = 0;
    this.sql_time = 0;

    this.sql_insert = 0;
    this.sql_update = 0;
    this.sql_delete = 0;
    this.sql_select = 0;
    this.sql_others = 0;

    this.executed_sqlhash = 0;
    this.active_sqlhash = 0;
    this.active_dbc = 0;
    //this.active_crud = 0;

    this.httpc_count = 0;
    this.httpc_time = 0;
    this.httpc_url = '';

    this.active_httpc_hash = 0;
    this.httpc_host = '';
    this.httpc_port = 0;

    this.userid = Long.ZERO;
    this.userAgent = 0;
    this.userAgentString = '';
    this.referer = 0;
    this.login = '';
    this.debug_sql_call = false;
    this.lastSqlStep = null; /*SqlStepX*/
    this.profileActive = 0;

    this.jdbc_updated = false;
    this.jdbc_update_record = 0;
    this.jdbc_identity = 0;
    this.jdbc_commit = 0;
    this.resultSql = new IntKeyMap().setMax(11);

    this.rs_count = 0;
    this.rs_time = 0;
    this.db_opening = false;
	this.socket_connecting = false;

    this.mtid=Long.ZERO;
    this.mdepth = 0;
    this.mcaller_pcode = 0;
    this.mcaller_okind = 0;
	this.mcaller_oid = 0;
	this.mcallee = Long.ZERO;
	this.custid = null;
    this.mcaller_txid = Long.ZERO;
	this.mcaller_spec = null;
	this.mcaller_url_hash = 0;
    this.mtid_build_checked = false;
    
    this.stack = [];

    this.http_host='';
    this.http_host_hash=0;
    
    this.last_footprint_time=Date.now();
    this.last_footprint_desc="start transaction";

    this.mcaller_stepId = Long.ZERO;
}

TraceContext.prototype.footprint=function(desc){
   this.last_footprint_desc=desc;
}
TraceContext.prototype.getElapsedTime = function () {
    return Date.now() - this.start_time;
}
TraceContext.prototype.resetStartTime = function () {
    this.start_time = Date.now();
}

var poids= new StringKeyLinkedMap(7, 1).setMax(301);
TraceContext.prototype.setCallerPOID= function (poidStr) {
    try {
        var poid = poids.get(poidStr);
        if (poid==null) {
            var x = poidStr.indexOf(',');
            var s1 = poidStr.substring(0, x);
            var pcode =  Hexa32.toNumber32(s1);
            var y = poidStr.indexOf( ',',x + 1);
            s1 = poidStr.substring(x + 1, y);
            var okind = ((s1.length == 0) ? 0 :Hexa32.toNumber32(s1));
            s1 = poidStr.substring(y + 1);
            var oid = s1.length == 0 ? 0 :  Hexa32.toNumber32(s1);
            poid = {pcode : pcode, okind :okind, oid:oid};
            poids.put(poidStr, poid);
        }
        this.mcaller_pcode = poid.pcode;
        this.mcaller_okind = poid.okind;
        this.mcaller_oid = poid.oid;
    } catch (e) {
        Logger.printError('WHATAP-999', 'TraceContext (setCallerPOID)', e, true);
    }
};
module.exports = TraceContext;