const DataOutputX = require('../io/data-outputx');
const DataInputX = require('../io/data-inputx');
const MapValue = require('../value/map-value');
const LINK = require('./link');
const net = require('net');

function NodeInfo() {
    this.attr = new MapValue();
    this.listen = new Set();
    this.outter = new Set();

    this.addListen = function (localIPs, address) {
        const ipo = this.getIPPORT(address);
        if (!ipo || this.isLocal127(ipo)) return;

        if (ipo.ip === '*' || ipo.ip === '0.0.0.0' || ipo.ip === '::') {
            localIPs.forEach(local_ip => {
                const k = LINK.create(local_ip, parseInt(ipo.port, 10));
                if (k) this.listen.add(k);
            });
        } else {
            const k = LINK.create(ipo.ip, parseInt(ipo.port, 10));
            if (k) this.listen.add(k);
        }
    };

    this.addOutter = function (local, remote) {
        const localIPO = this.getIPPORT(local);
        if (!localIPO || this.isIPv6(localIPO)) return;
        if (this.hasListen(localIPO.ip, localIPO.port)) return;

        const remoteIPO = this.getIPPORT(remote);
        if (!remoteIPO || this.isIPv6(remoteIPO) || this.isLocal127(remoteIPO)) return;

        const k = LINK.create(remoteIPO.ip, parseInt(remoteIPO.port, 10));
        if (k) this.outter.add(k);
    };

    this.hasListen = function (ip, port) {
        const k = LINK.create(ip, parseInt(port, 10));
        return this.listen.has(k);
    };

    this.getIPPORT = function (address) {
        try {
            const ipo = {};
            const x = address.lastIndexOf(':');
            ipo.ip = address.substring(0, x);
            ipo.port = address.substring(x + 1);
            return ipo;
        } catch (e) {
            return null;
        }
    };

    this.toBytes = function () {
        const out = new DataOutputX();
        out.writeByte(0);
        out.writeValue(this.attr);
        this.toLinkBytes(this.listen, out);
        this.toLinkBytes(this.outter, out);
        return out.toByteArray();
    };

    this.toObject = function (b) {
        const din = new DataInputX(b);
        const ver = din.readByte();
        this.attr = din.readValue();
        this.listen = this.toLinkObject(din);
        this.outter = this.toLinkObject(din);
        return this;
    };

    this.toLinkObject = function (din) {
        const data = new Set();
        const sz = din.readDecimal();
        for (let i = 0; i < sz; i++) {
            data.add(new LINK().toObject(din));
        }
        return data;
    };

    this.toLinkBytes = function (data, out) {
        out.writeDecimal(data.size);
        if (data.size === 0) return;
        data.forEach(k => k.toBytes(out));
    };

    this.toJSON = function () {
        const o = new Map();
        o.put('attr', JSON.stringify(this.attr));
        o.put('listen', JSON.parse(this.listen));
        o.put('outter', JSON.parse(this.outter));
        return o;
    };

    this.toJSON = function (data) {
        const out = new JSONArray();
        data.forEach(k => out.put(k.toString()));
        return out;
    };

    this.isIPv6 = function(data) {
        var ip = data.ip;
        if(ip){
            return net.isIPv6(ip);
        }
        return false;
    };

    this.isLocal127 = function (data) {
        var ip = data.ip;
        if(ip){
            return ip === '127.0.0.1';
        }
        return false;
    }
}

NodeInfo.prototype = new NodeInfo();
NodeInfo.prototype.constructor = NodeInfo;

module.exports = NodeInfo;
