var { InetAddress } = require('net');
var CompareUtil = require('../util/compare-util');
var HashUtil = require('../util/hashutil');

function LINK() {
    this.ip = null;
    this.port = 0;

    this.toString = function () {
        if (this.ip === null) return `0.0.0.0:${this.port}`;
        try {
            return `${InetAddress.getByAddress(this.ip).getHostAddress()}:${this.port}`;
        } catch (e) {
            return `0.0.0.0:${this.port}`;
        }
    };

    this.include = function (k) {
        if (!CompareUtil.equals(this.ip, k.ip)) return false;
        if (this.port === 0) return true;
        return this.port === k.port;
    };

    this.equals = function (o) {
        if (o.constructor !== this.constructor) return false;
        var k = o;
        if (!CompareUtil.equals(this.ip, k.ip)) return false;
        return this.port === k.port;
    };

    this.hashCode = function () {
        return HashUtil.hash(this.ip) | this.port;
    };

    this.toBytes = function (out) {
        out.writeBlob(this.ip);
        out.writeInt(this.port);
        return this;
    };

    this.toObject = function (din) {
        this.ip = din.readBlob();
        this.port = din.readInt();
        return this;
    };
}

LINK.create = function (ipStr, port) {
    var k = new LINK();
    try {
        k.ip = InetAddress.getByName(ipStr).getAddress();
    } catch (e) {
        k.ip = new Buffer(4);
    }
    k.port = port;
    return k;
};

LINK.prototype = new LINK();
LINK.prototype.constructor = LINK;

module.exports = LINK;

