/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var MethodStepX = require('./method-stepx'),
    SqlStepX = require('./sql-stepx'),
    ResultSetStep = require('./resultset-step'),
    SocketStep = require('./socket-step'),
    HTtpStepX = require('./http-stepx'),
    ActiveStackStep = require('./activestack-step'),
    MessageStep = require('./message-step'),
    SecureMsgStep = require('./securemsg-step'),
    DBCStep = require('./dbc-step');

exports.METHOD = 1;
exports.SQL = 2;
exports.RESULTSET = 3;
exports.HTTPCALL = 4;
exports.SOCKET = 5;
exports.ACTIVE_STACK = 6;
exports.MESSAGE = 7;
exports.DBC = 8;
exports.SQL_2 = 9;
exports.METHOD_2 = 11;
exports.SECURE_MESSAGE = 15;

exports.METHOD_X = 17;
exports.SQL_X = 18;
exports.HTTPCALL_X = 19;

exports.create = function(type) {
    switch (type) {
        case this.METHOD_X:
            return new MethodStepX();
        case this.SQL_X:
            return new SqlStepX();
        case this.RESULTSET:
            return new ResultSetStep();
        case this.SOCKET:
            return new SocketStep();
        case this.HTTPCALL_X:
            return new HTtpStepX();
        case this.ACTIVE_STACK:
            return new ActiveStackStep();
        case this.MESSAGE:
            return new MessageStep();
        case this.SECURE_MESSAGE:
            return new SecureMsgStep();
        case this.DBC:
            return new DBCStep();
    };
};