/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var DataOutputX = require('../io/data-outputx'),
    DataInputX = require('../io/data-inputx');

function Step() {
    this.parent = 0;
    this.index = 0;
    this.start_time = 0;
    this.opt = 0;
};

Step.prototype.getStepType = function() {};
Step.prototype.getOrder = function () {
    return this.index;
};
Step.prototype.write = function(dout) {
    dout.writeDecimal(this.parent);
    dout.writeDecimal(this.index);
    dout.writeDecimal(this.start_time);
};
Step.prototype.read = function(din) {
    this.parent = din.readDecNumber();
    this.index = din.readDecNumber();
    this.start_time = din.readDecNumber();
    return this;
};
Step.prototype.compareTo = function(step) {
    return this.getOrder() - step.getOrder();
};
Step.prototype.isTrue = function(flag) {
    return (this.opt & flag) != 0;
};
Step.prototype.setTrue = function(flag) {
    this.opt |= flag;
};

Step.toBytes = function(p) {
    if(p == null ) {
        return null;
    }
    var dout = new DataOutputX(p.length * 30);

    for(var i=0; i< p.length; i++) {
        dout.writeStep(p[i]);
    }

    return dout.toByteArray();
};
Step.toObjects = function(buff) {
    if(buff == null ) {
        return null;
    }
    var arr = [],
        din = new DataInputX(buff);
    while(din.available() > 0) {
        arr.push(din.readStep());
    }
    return arr;
};

module.exports = Step;