/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Step        = require('./step'),
    StepEnum    = require('./stepenum'),
    Long        = require('long');

function SqlStepX() {
    Step.call(this);

    this.xtype = 0;
    this.hash = 0;
    this.elapsed = 0;
    this.error = Long.ZERO;
    this.updated = 0;
    this.dbc = 0;

    this.p1 = null;
    this.p2 = null;
    this.pcrc = 0;

    this.start_cpu = 0;
    this.start_mem = 0;  
    this.stack = [];

};
SqlStepX.prototype = new Step();
SqlStepX.prototype.constructor = SqlStepX;
SqlStepX.prototype.getStepType = function () {
    return StepEnum.SQL_X;
};
SqlStepX.prototype.write = function (dout) {
    Step.prototype.write.call(this, dout);
    dout.writeByte(0);
    dout.writeDecimal(this.hash);
    dout.writeDecimal(this.elapsed);
    dout.writeDecimal(this.error);
    dout.writeByte(this.xtype);
    dout.writeDecimal(this.dbc);
    dout.writeBlob(this.p1);
    dout.writeBlob(this.p2);
    dout.writeByte(this.pcrc);
    dout.writeDecimal(this.start_cpu);
    dout.writeDecimal(this.start_mem);
    dout.writeIntArray(this.stack);
};
SqlStepX.prototype.read = function (din) {
    Step.prototype.read.call(this, din);
    var ver = din.readByte();
    this.hash = din.readDecNumber();
    this.elapsed = din.readDecNumber();
    this.error = din.readDecNumber();
    this.xtype = din.readByte();
    this.dbc = din.readDecNumber();
    this.p1 = din.readBlob();
    this.p2 = din.readBlob();
    this.pcrc = din.readByte();
    this.start_cpu = din.readDecNumber();
    this.start_mem = din.readDecNumber();
    this.stack = din.readIntArray();
 
     return this;
};

module.exports = SqlStepX;