/**
 * Copyright 2016 the WHATAP project authors. All rights reserved.
 * Use of this source code is governed by a license that
 * can be found in the LICENSE file.
 */

var Step        = require('./step'),
    StepEnum    = require('./stepenum'),
    Long        = require('long');

function SocketStep(ipaddr, port) {
    Step.call(this);

    this.ipaddr = null; /*Buffer*/
    this.port = 0;
    this.elapsed = 0;
    this.error = Long.ZERO;

    if(Array.isArray(ipaddr)) {
        this.ipaddr = ipaddr;
        this.port = port;
    }
}

SocketStep.prototype = new Step();
SocketStep.prototype.constructor = SocketStep;
SocketStep.prototype.getStepType = function () {
    return StepEnum.SOCKET;
};
SocketStep.prototype.write = function(dout) {
    Step.prototype.write.call(this, dout);
    dout.writeBlob(this.ipaddr);
    dout.writeDecimal(this.port);
    dout.writeDecimal(this.elapsed);
    dout.writeDecimal(this.error);
};
SocketStep.prototype.read = function(din) {
    Step.prototype.read.call(this, din);
    this.ipaddr = din.readBlob();
    this.port = din.readDecNumber();
    this.elapsed = din.readDecNumber();
    this.error = din.readDecLong();
    return this;
};

module.exports = SocketStep;
